<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * VistaReporteProducto Entity
 *
 * @property int $producto_id
 * @property string $nombre_producto
 * @property string|null $descripcion_producto
 * @property int|null $stock_actual
 * @property int|null $stock_minimo
 * @property string $precio
 * @property \Cake\I18n\Date $fecha_ingreso
 * @property \Cake\I18n\Date|null $fecha_vencimiento
 * @property string|null $ubicacion
 * @property string|null $estado
 * @property string|null $categoria_nombre
 * @property string|null $categoria_descripcion
 * @property string|null $proveedor_nombre
 * @property string|null $contacto_nombre
 * @property string|null $contacto_email
 * @property string|null $contacto_telefono
 * @property string|null $proveedor_direccion
 * @property int|null $transaccion_id
 * @property string|null $tipo_transaccion
 * @property int|null $cantidad_transaccion
 * @property \Cake\I18n\DateTime|null $fecha_transaccion
 * @property string|null $notas
 * @property int|null $user_id
 *
 * @property \App\Model\Entity\Producto $producto
 * @property \App\Model\Entity\User $user
 */
class VistaReporteProducto extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'producto_id' => true,
        'nombre_producto' => true,
        'descripcion_producto' => true,
        'stock_actual' => true,
        'stock_minimo' => true,
        'precio' => true,
        'fecha_ingreso' => true,
        'fecha_vencimiento' => true,
        'ubicacion' => true,
        'estado' => true,
        'categoria_nombre' => true,
        'categoria_descripcion' => true,
        'proveedor_nombre' => true,
        'contacto_nombre' => true,
        'contacto_email' => true,
        'contacto_telefono' => true,
        'proveedor_direccion' => true,
        'transaccion_id' => true,
        'tipo_transaccion' => true,
        'cantidad_transaccion' => true,
        'fecha_transaccion' => true,
        'notas' => true,
        'user_id' => true,
        'producto' => true,
        'user' => true,
    ];
}
