<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * VistaReporteProductos Model
 *
 * @property \App\Model\Table\ProductosTable&\Cake\ORM\Association\BelongsTo $Productos
 * @property \App\Model\Table\UsersTable&\Cake\ORM\Association\BelongsTo $Users
 *
 * @method \App\Model\Entity\VistaReporteProducto newEmptyEntity()
 * @method \App\Model\Entity\VistaReporteProducto newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\VistaReporteProducto> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\VistaReporteProducto get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\VistaReporteProducto findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\VistaReporteProducto patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\VistaReporteProducto> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\VistaReporteProducto|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\VistaReporteProducto saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\VistaReporteProducto>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\VistaReporteProducto>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\VistaReporteProducto>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\VistaReporteProducto> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\VistaReporteProducto>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\VistaReporteProducto>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\VistaReporteProducto>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\VistaReporteProducto> deleteManyOrFail(iterable $entities, array $options = [])
 */
class VistaReporteProductosTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('vista_reporte_productos');
        $this->setDisplayField('nombre_producto');

        $this->belongsTo('Productos', [
            'foreignKey' => 'producto_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Users', [
            'foreignKey' => 'user_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('producto_id')
            ->notEmptyString('producto_id');

        $validator
            ->scalar('nombre_producto')
            ->maxLength('nombre_producto', 255)
            ->requirePresence('nombre_producto', 'create')
            ->notEmptyString('nombre_producto');

        $validator
            ->scalar('descripcion_producto')
            ->allowEmptyString('descripcion_producto');

        $validator
            ->integer('stock_actual')
            ->allowEmptyString('stock_actual');

        $validator
            ->integer('stock_minimo')
            ->allowEmptyString('stock_minimo');

        $validator
            ->decimal('precio')
            ->requirePresence('precio', 'create')
            ->notEmptyString('precio');

        $validator
            ->date('fecha_ingreso')
            ->requirePresence('fecha_ingreso', 'create')
            ->notEmptyDate('fecha_ingreso');

        $validator
            ->date('fecha_vencimiento')
            ->allowEmptyDate('fecha_vencimiento');

        $validator
            ->scalar('ubicacion')
            ->maxLength('ubicacion', 255)
            ->allowEmptyString('ubicacion');

        $validator
            ->scalar('estado')
            ->allowEmptyString('estado');

        $validator
            ->scalar('categoria_nombre')
            ->maxLength('categoria_nombre', 255)
            ->allowEmptyString('categoria_nombre');

        $validator
            ->scalar('categoria_descripcion')
            ->allowEmptyString('categoria_descripcion');

        $validator
            ->scalar('proveedor_nombre')
            ->maxLength('proveedor_nombre', 255)
            ->allowEmptyString('proveedor_nombre');

        $validator
            ->scalar('contacto_nombre')
            ->maxLength('contacto_nombre', 255)
            ->allowEmptyString('contacto_nombre');

        $validator
            ->scalar('contacto_email')
            ->maxLength('contacto_email', 255)
            ->allowEmptyString('contacto_email');

        $validator
            ->scalar('contacto_telefono')
            ->maxLength('contacto_telefono', 20)
            ->allowEmptyString('contacto_telefono');

        $validator
            ->scalar('proveedor_direccion')
            ->allowEmptyString('proveedor_direccion');

        $validator
            ->integer('transaccion_id')
            ->allowEmptyString('transaccion_id');

        $validator
            ->scalar('tipo_transaccion')
            ->maxLength('tipo_transaccion', 200)
            ->allowEmptyString('tipo_transaccion');

        $validator
            ->integer('cantidad_transaccion')
            ->allowEmptyString('cantidad_transaccion');

        $validator
            ->dateTime('fecha_transaccion')
            ->allowEmptyDateTime('fecha_transaccion');

        $validator
            ->scalar('notas')
            ->allowEmptyString('notas');

        $validator
            ->integer('user_id')
            ->allowEmptyString('user_id');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['producto_id'], 'Productos'), ['errorField' => 'producto_id']);
        $rules->add($rules->existsIn(['user_id'], 'Users'), ['errorField' => 'user_id']);

        return $rules;
    }
}
