<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Reporte de Citas</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #000;
            padding: 4px;
            text-align: left;
            font-size: 9px;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .estado-header {
            font-weight: bold;
            background-color: #f2f2f2;
        }
        .estado-header td {
            font-size: 10px;
        }
    </style>
</head>
<body>
    <h1>Reporte de Citas</h1>
    <p>Fecha Inicio: <?= $fechaInicio->format('Y-m-d') ?></p>
    <p>Fecha Fin: <?= $fechaFin->format('Y-m-d') ?></p>
    <p>Total de Citas: <?= $totalCitas ?></p>
    
    <p><strong>Filtrado por:</strong> <?= h($tipoFecha === 'created_at' ? 'Fecha de Creación' : 'Fecha de Cita') ?></p>

    <?php if ($username): ?>
        <p><strong>Usuario:</strong> <?= h($username) ?></p>
    <?php endif; ?>
    <?php if ($estadoFiltro): ?>
        <p><strong>Estado:</strong> <?= h($estadoFiltro) ?></p>
    <?php endif; ?>

    <table>
        <thead>
            <tr>
                <th>Estado</th>
                <th>Total</th>
                <th>Paciente</th>
                <th>Doctor</th>
                <th><?= $tipoFecha === 'created_at' ? 'Fecha de Creación' : 'Fecha de Cita' ?></th>
                <th>Motivo</th>
                <th>Duración (min)</th>
                <th>Hora Llegada</th>
                <th>Inicio Consulta</th>
                <th>Fin Consulta</th>
                <th>Usuario</th>
                <th>Campaña</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($citasAgrupadas as $estado => $detalles): ?>
                <tr class="estado-header">
                    <td><?= h($estado) ?></td>
                    <td><?= h($detalles['total']) ?></td>
                    <td colspan="10"></td>
                </tr>
                <?php foreach ($detalles['citas'] as $cita): ?>
                    <tr>
                        <td></td>
                        <td></td>
                        <td><?= h($cita['paciente']) ?></td>
                        <td><?= h($cita['doctor']) ?></td>
                        <td><?= h($cita['fecha_mostrar']) ?></td>
                        <td><?= h($cita['motivo']) ?></td>
                        <td><?= h($cita['duracion_minutos']) ?></td>
                        <td><?= h($cita['hora_llegada']) ?></td>
                        <td><?= h($cita['hora_inicio_consulta']) ?></td>
                        <td><?= h($cita['hora_fin_consulta']) ?></td>
                        <td><?= h($cita['usuario']) ?></td>
                        <td><?= h($cita['campana']) ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
