<div class="container mt-4">
    <h2 class="mb-3 text-info">Editar Consulta</h2>

    <?= $this->Form->create($consulta, ['type' => 'file', 'class' => 'needs-validation']) ?>

    <div class="mb-3">
        <?= $this->Form->control('paciente_id', [
            'label' => 'Paciente',
            'options' => $pacientes,
            'empty' => 'Seleccione un paciente',
            'class' => 'form-control',
            'default' => $consulta->historias_clinica->paciente_id,
            'disabled' => true
        ]) ?>
    </div>

    <div class="row">
        <div class="col-md-12">
            <?= $this->Form->control('motivo', ['label' => 'Motivo de consulta', 'class' => 'form-control mb-2']) ?>
            <?= $this->Form->control('examen_fisico', ['label' => 'Examen físico', 'class' => 'form-control mb-2']) ?>
            <?= $this->Form->control('diagnostico', ['label' => 'Diagnóstico', 'class' => 'form-control mb-2']) ?>
        </div>

        <div class="col-md-12">
            <div class="mb-3 position-relative">
                <label for="cie-search">CIE-10</label>
                <input type="text" id="cie-search" class="form-control" placeholder="Escribe para buscar..." autocomplete="off">
                <div id="cie-suggestions" class="list-group position-absolute w-100" style="display: none; z-index: 1000;"></div>
            </div>

<div id="selected-cies">
    <?php if (!empty($consulta->consultas_cie)): ?>
        <?php foreach ($consulta->consultas_cie as $cie): ?>
            <?php
                $descripcion = '';
                $clave = '';
                $id = null;

                // 1. Si es un diagnóstico CIE
                if (!empty($cie->diagnosticoscie10)) {
                    $descripcion = $cie->diagnosticoscie10->descripcion;
                    $clave = $cie->diagnosticoscie10->clave;
                    $id = $cie->cie_id;
                }

                // 2. Si es una categoría (esto sobreescribe si cie_id es null y categoria sí tiene valor)
                if (empty($descripcion) && !empty($cie->categoriascie10)) {
                    $descripcion = $cie->categoriascie10->descripcion;
                    $clave = $cie->categoriascie10->clave;
                    $id = $cie->categoria_id;
                }

                if ($id !== null):
                    $json = json_encode(['id' => $id, 'clave' => $clave]);
            ?>
                <span class="badge bg-light text-dark border me-2 p-2 d-inline-block mb-2">
                    <?= h($clave . ' - ' . $descripcion) ?>
                </span>
                <input type="hidden" name="cie_data[]" value='<?= $json ?>'>
            <?php endif; ?>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

            <?= $this->Form->hidden('user_id', ['value' => $usuario->id]) ?>

            <?= $this->Form->hidden('doctor_id', [
                'label' => 'Doctor',
                'options' => $doctores,
                'class' => 'form-control mb-2',
                'empty' => 'Seleccione un doctor'
            ]) ?>

            <?= $this->Form->control('prescripcion', ['label' => 'Prescripción', 'class' => 'form-control mb-2']) ?>

            <?= $this->Form->control('orden_medico', ['label' => 'Orden Médica', 'class' => 'form-control mb-2']) ?>

            <h5>Documentos Adjuntos</h5>
            <?php if (!empty($consulta->documentos_consultas)): ?>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>Previsualización</th>
                                <th>Acción</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($consulta->documentos_consultas as $docConsulta): ?>
                                <?php $documento = $docConsulta->documento; ?>
                                <tr>
                                    <td><?= h(basename($documento->ruta_archivo)) ?></td>
                                    <td>
                                        <?php
                                            $rutaArchivo = '/' . h($documento->ruta_archivo);
                                            $ext = strtolower(pathinfo($documento->ruta_archivo, PATHINFO_EXTENSION));
                                        ?>
                                        <?php if (in_array($ext, ['jpg', 'jpeg', 'png'])): ?>
                                            <img src="<?= $this->Url->build($rutaArchivo, ['fullBase' => true]) ?>" class="img-thumbnail" style="max-width: 100px;">
                                        <?php elseif ($ext === 'pdf'): ?>
                                            <iframe src="<?= $this->Url->build($rutaArchivo, ['fullBase' => true]) ?>" style="width: 100px; height: 100px;" frameborder="0"></iframe>
                                        <?php else: ?>
                                            <i class="fas fa-file-alt"></i> Archivo no visualizable
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?= $this->Html->link('Ver', $rutaArchivo, ['target' => '_blank', 'class' => 'btn btn-info btn-sm']) ?>
                                        <?= $this->Html->link('Descargar', $rutaArchivo, ['download' => true, 'class' => 'btn btn-success btn-sm']) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p>No hay documentos adjuntos.</p>
            <?php endif; ?>

            <h5>Agregar nuevos documentos</h5>
            <div class="col-md-14 mx-auto mb-3">
                <?= $this->Form->control('documentos_temp', [
                    'type' => 'file',
                    'label' => 'Agregar Documento',
                    'class' => 'form-control',
                    'id' => 'documentosTemp',
                    'multiple' => true
                ]) ?>
            </div>
            <div class="col-md-14 mx-auto mb-3">
    <ul id="lista-documentos" class="list-group mb-3"></ul>
    <input type="file" id="documentosFinal" name="documentos[]" multiple style="display: none;">
</div>
        </div>
    </div>

    <div class="col-12 text-center mt-3 mb-2">
        <?= $this->Form->button(__('Actualizar Consulta'), ['class' => 'btn btn-primary']) ?>
        <?= $this->Html->link(__('Cancelar'), ['controller' => 'Pacientes', 'action' => 'view', $consulta->historias_clinica->paciente_id], ['class' => 'btn btn-secondary']) ?>
    </div>

    <?= $this->Form->end() ?>
</div>

<script>
    function initializeFormLogic(context) {
        // Usar atributo data en el contexto para rastrear inicialización
        const key = 'formLogicInitialized_' + Math.random();
        if (context._formLogicKey) return;
        context._formLogicKey = key;

        const inputTemp = context.querySelector('#documentosTemp');
        const inputFinal = context.querySelector('#documentosFinal');
        const lista = context.querySelector('#lista-documentos');

        if (!inputTemp || !inputFinal || !lista) {
            console.warn('No se encontraron elementos de documentos');
            delete context._formLogicKey;
            return;
        }

        let archivosSeleccionados = [];

        inputTemp.addEventListener('change', function (e) {
            e.preventDefault();
            e.stopPropagation();
            
            const nuevosArchivos = Array.from(this.files || []);
            nuevosArchivos.forEach(nuevoArchivo => {
                if (!nuevoArchivo) return;

                if (archivosSeleccionados.some(file => file.name === nuevoArchivo.name && file.size === nuevoArchivo.size)) {
                    alert(`El archivo ${nuevoArchivo.name} ya fue agregado.`);
                    return;
                }

                archivosSeleccionados.push(nuevoArchivo);
            });

            actualizarListaVisual();
            actualizarInputFinal();
            inputTemp.value = '';
        });

        function actualizarListaVisual() {
            lista.innerHTML = '';
            archivosSeleccionados.forEach((file, index) => {
                const li = document.createElement('li');
                li.className = 'list-group-item d-flex justify-content-between align-items-center';
                li.textContent = file.name + ' (' + (file.size / 1024).toFixed(2) + ' KB)';

                const btnEliminar = document.createElement('button');
                btnEliminar.type = 'button';
                btnEliminar.textContent = 'x';
                btnEliminar.className = 'btn btn-sm btn-danger';
                btnEliminar.addEventListener('click', function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    archivosSeleccionados.splice(index, 1);
                    actualizarListaVisual();
                    actualizarInputFinal();
                });

                li.appendChild(btnEliminar);
                lista.appendChild(li);
            });
        }

        function actualizarInputFinal() {
            try {
                const dataTransfer = new DataTransfer();
                archivosSeleccionados.forEach(file => {
                    dataTransfer.items.add(file);
                });
                inputFinal.files = dataTransfer.files;
                console.log('Archivos en el input final:', inputFinal.files.length);
            } catch (error) {
                console.error('Error al actualizar input final:', error);
            }
        }
    }

    function initializeCieSearch(context) {
        // Usar atributo data en el contexto para rastrear inicialización
        const key = 'cieLogicInitialized_' + Math.random();
        if (context._cieLogicKey) return;
        context._cieLogicKey = key;

        const searchInput = context.querySelector("#cie-search");
        const suggestionsList = context.querySelector("#cie-suggestions");
        const selectedCies = context.querySelector("#selected-cies");

        if (!searchInput || !suggestionsList || !selectedCies) {
            delete context._cieLogicKey;
            return;
        }

        searchInput.addEventListener("input", function () {
            const query = searchInput.value.trim().toLowerCase();

            if (query.length < 2) {
                suggestionsList.style.display = "none";
                return;
            }

            fetch("<?= $this->Url->build(['controller' => 'Consultas', 'action' => 'buscarCie']) ?>?q=" + encodeURIComponent(query))
                .then(response => response.json())
                .then(data => {
                    suggestionsList.innerHTML = "";

                    if (data.length === 0) {
                        suggestionsList.style.display = "none";
                        return;
                    }

                    const limitedData = data.slice(0, 10);

                    limitedData.forEach(item => {
                        const div = document.createElement("div");
                        div.classList.add("list-group-item", "list-group-item-action", "cie-item");
                        div.textContent = `${item.clave} - ${item.descripcion}`;
                        div.dataset.id = item.id;

                        div.addEventListener("click", function () {
                            addSelectedCie(item);
                            suggestionsList.style.display = "none";
                        });

                        suggestionsList.appendChild(div);
                    });

                    suggestionsList.style.display = "block";
                })
                .catch(error => console.error("Error en la búsqueda:", error));
        });

        function addSelectedCie(item) {
            const existingInputs = selectedCies.querySelectorAll('input[name="cie_data[]"]');
            for (let input of existingInputs) {
                try {
                    const jsonValue = JSON.parse(input.value);
                    if (jsonValue.id === item.id) {
                        alert(`El CIE ${item.clave} ya fue agregado.`);
                        return;
                    }
                } catch (e) {
                    console.error('Error parsing CIE data:', e);
                }
            }

            const input = document.createElement("input");
            input.type = "hidden";
            input.name = "cie_data[]";
            input.value = JSON.stringify({ id: item.id, clave: item.clave });
            
            const span = document.createElement("span");
            span.textContent = `${item.clave} - ${item.descripcion} `;
            span.classList.add("badge", "bg-light", "text-dark", "border", "me-2", "p-2", "d-inline-block", "mb-2");

            const removeBtn = document.createElement("button");
            removeBtn.type = "button";
            removeBtn.innerHTML = '<i class="fas fa-trash-alt"></i>';
            removeBtn.classList.add("btn", "btn-sm", "btn-outline-danger", "ms-1");
            removeBtn.addEventListener("click", function (e) {
                e.preventDefault();
                e.stopPropagation();
                input.remove();
                span.remove();
            });

            span.appendChild(removeBtn);
            selectedCies.appendChild(input);
            selectedCies.appendChild(span);

            searchInput.value = "";
        }
    }

    // Al cargar la página
    document.addEventListener("DOMContentLoaded", function () {
        initializeFormLogic(document);
        initializeCieSearch(document);
    });

    // Cuando se abre un modal
    $(document).on('shown.bs.modal', function (e) {
        const modalContent = e.target.querySelector('.modal-content');
        if (modalContent) {
            initializeFormLogic(modalContent);
            initializeCieSearch(modalContent);
        }
    });

    // Si usas AJAX (por ejemplo, al cargar contenido por Pjax, Turbo, etc.)
    $(document).on('ajaxComplete', function () {
        initializeFormLogic(document);
        initializeCieSearch(document);
    });
</script>

<style>

    #cie-suggestions .cie-item {
        /* color: white; */
        color: #212529;
        background-color: #f8f9fa;
        padding: 10px;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    #cie-suggestions .cie-item:hover {
        /* background-color: #6c757d; */
        background-color: #e2e6ea;
    }
</style>