<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Consulta $consulta
 */
?>
<div class="container mt-4">
<div class="card p-4 shadow-none border-0">
        <h3 class="text-start text-info mb-4">Consulta</h3>
        <div class="table-responsive">
        <table class="table table-bordered" >
            <tbody>
            <tr>
                <th style="text-start">Motivo</th>
                <td style="white-space: pre-line;" ><?= h($consulta->motivo) ?></td>
            </tr>

                <tr>
                    <th >Examen Fisico</th>
                    <td  style="white-space: pre-line;"><?= h($consulta->examen_fisico) ?></td>
                </tr>
                <tr>
                    <th >Diagnostico</th>
                    <td  style="white-space: pre-line;"><?= h($consulta->diagnostico) ?></td>
                </tr>
                <tr>
                    <th >Prescripción</th>
                    <td  style="white-space: pre-line;"><?= h($consulta->prescripcion) ?></td>
                </tr>
                <tr>
    <th class="text-center">CIEs</th>
    <td class="text-center">
        <?php if (!empty($consulta->consultas_cie)) : ?>
            <ul class="list-group list-group-flush">
                <?php foreach ($consulta->consultas_cie as $cie) : ?>
                    <?php
                        $clave = '';
                        $descripcion = '';

                        if (!empty($cie->diagnosticoscie10)) {
                            $clave = $cie->diagnosticoscie10->clave;
                            $descripcion = $cie->diagnosticoscie10->descripcion;
                        } elseif (!empty($cie->categoriascie10)) {
                            $clave = $cie->categoriascie10->clave;
                            $descripcion = $cie->categoriascie10->descripcion;
                        }
                    ?>

                    <?php if ($clave && $descripcion) : ?>
                        <li class="list-group-item">
                            <strong><?= h($clave) ?></strong> - <?= h($descripcion) ?>
                        </li>
                    <?php else : ?>
                        <li class="list-group-item text-warning">⚠️ CIE no disponible</li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>
        <?php else : ?>
            <span class="">No hay CIEs registrados.</span>
        <?php endif; ?>
    </td>
</tr>
                <tr>
                    <th >Registrado por</th>
                    <td ><?= $consulta->hasValue('user') ? $this->Html->link($consulta->user->username, ['controller' => 'Users', 'action' => 'view', $consulta->user->id], ['class' => 'text-info']) : 'N/A' ?></td>
                </tr>
<tr>
    <th >Orden Médico</th>
    <td style="white-space: pre-line;"><?= h($consulta->orden_medico) ?></td>
</tr>
            </tbody>
        </table>
    </div>
        
    <h4 class="mt-5 ">📎 Documentos Adjuntos</h4>

<?php if (!empty($consulta->documentos_consultas)): ?>
    <div class="table-responsive">
        <table class="table  table-bordered align-middle">
            <thead class="table-secondary text-dark">
                <tr>
                    <th scope="col" class="text-center">ID</th>
                    <th scope="col" class="text-center">Previsualización</th>
                    <th scope="col" class="text-center">Acción</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($consulta->documentos_consultas as $docConsulta): ?>
                    <?php $documento = $docConsulta->documento; ?>
                    <?php if ($documento): ?>
                        <tr>
                            <td class="text-center"><?= h($documento->id) ?></td>
                            <td class="text-center">
                                <?php
                                    $rutaArchivo = '/' . h($documento->ruta_archivo);
                                    $extension = strtolower(pathinfo($documento->ruta_archivo, PATHINFO_EXTENSION));
                                ?>
                                <?php if (in_array($extension, ['png', 'jpg', 'jpeg'])): ?>
                                    <img src="<?= $this->Url->build($rutaArchivo, ['fullBase' => true]) ?>" 
                                         alt="Imagen" class="img-thumbnail border border-light" style="max-width: 100px;">
                                <?php elseif ($extension === 'pdf'): ?>
                                    <iframe src="<?= $this->Url->build($rutaArchivo, ['fullBase' => true]) ?>" 
                                            style="width: 100px; height: 100px;" frameborder="0" class="border border-light"></iframe>
                                <?php else: ?>
                                    <i class="fas fa-file-alt text-secondary fs-4"></i> <span class="text-muted">Archivo no visualizable</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                            <?= $this->Html->link(
                                '<i class="fas fa-eye me-1"></i> Ver',
                                $rutaArchivo,
                                [
                                    'escape' => false,
                                    'target' => '_blank',
                                    'class' => 'btn btn-info btn-sm me-1'
                                ]
                            ) ?>

                            <?= $this->Html->link(
                                '<i class="fas fa-download me-1"></i> Descargar',
                                $rutaArchivo,
                                [
                                    'escape' => false,
                                    'download' => true,
                                    'class' => 'btn btn-success btn-sm'
                                ]
                            ) ?>

                            </td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php else: ?>
    <div class="alert alert-secondary mt-3 text-center">
        <i class="fas fa-info-circle me-2"></i>No hay documentos adjuntos.
    </div>
<?php endif; ?>


    </div>
</div>

<style>
    .table-bordered th, .table-bordered td {
        border: 1px solid #dddddd; /* Color de borde más claro */
    }
    
</style>