<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Departamento $departamento
 */
?>
<style>
    .label-text {
        font-weight: bold;
    }
    .data-box {
        border: 1px solid #ced4da;
        border-radius: 5px;
        padding: 5px 10px;
        min-height: 38px;
        display: flex;
        align-items: center;
    }
</style>

<div class="container mt-4 mb-4">
    <!-- Título -->
    <div class="mb-4">
        <h3 class="text-info"><i class="fas fa-building me-2"></i> Detalles del Lugar de Procedencia</h3>
    </div>

    <!-- Nombre -->
    <div class="row mb-3">
        <div class="col-md-3">
            <p class="label-text"><?= __('Nombre:') ?></p>
        </div>
        <div class="col-md-9">
            <div class="data-box"><?= h($departamento->nombre) ?></div>
        </div>
    </div>

    <!-- Fechas -->
    <div class="row mb-3">
        <div class="col-md-6">
            <p class="label-text"><?= __('Fecha de Creación:') ?></p>
            <div class="data-box"><?= h($departamento->created) ?></div>
        </div>
        <div class="col-md-6">
            <p class="label-text"><?= __('Última Modificación:') ?></p>
            <div class="data-box"><?= h($departamento->modified) ?></div>
        </div>
    </div>

    <!-- Botones de Acción -->
    <div class="col-12 mt-3 text-center">
        <?= $this->Html->link(__('Editar Lugar'), ['action' => 'edit', $departamento->id], ['class' => 'btn btn-warning me-2']) ?>
        <?= $this->Html->link(__('Regresar'), ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
    </div>
</div>