<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Paciente $paciente
 * @var \Cake\Collection\CollectionInterface|string[] $departamentos
 * @var \Cake\Collection\CollectionInterface|string[] $campanas
 * @var \Cake\Collection\CollectionInterface|string[] $users
 */
?>
<div class="container mt-4 mb-4">
    <?= $this->Form->create($paciente, ['class' => 'row g-3']) ?>

    <!-- Título -->
    <div class="col-12 mb-4 text-info">
        <h3><i class="fas fa-user-plus"></i> Agregar Paciente</h3>
    </div>

    <!-- Campos de Datos Personales -->
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('nombre', ['class' => 'form-control', 'label' => 'Nombres']) ?>
    </div>
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('apellido', ['class' => 'form-control', 'label' => 'Apellidos']) ?>
    </div>
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('telefono_celular', ['class' => 'form-control', 'label' => 'Teléfono Celular', 'pattern' => '^[0-9]{1,22}$', 'maxlength' => '22' , 'title' => 'Solo se permiten números']) ?>
    </div>

    <!-- Historia Clínica -->
    <div class="col-12 mb-3 text-info">
        <h4><i class="fas fa-notes-medical"></i> Historia Clínica</h4>
    </div>
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('historiaClinica.dni', ['class' => 'form-control', 'label' => 'DNI/Carnet de Extranjeria', 'required' => true, 'pattern' => '^[0-9]{7,20}$', 'maxlength' => '20', 'inputmode' => 'numeric', 'title' => 'Solo se permiten números']) ?>
    </div>
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('historiaClinica.fecha_nacimiento', ['class' => 'form-control', 'empty' => true, 'type' => 'date', 'id' => 'fecha-nacimiento' ,'label' => 'Fecha de Nacimiento', 'max' => date('Y-m-d')]) ?>
    </div>
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('historiaClinica.edad', ['class' => 'form-control', 'id' => 'edad' ,'label' => 'Edad', 'inputmode' => 'numeric', 'title' => 'Solo se permiten números']) ?>
    </div>
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('historiaClinica.sexo', [
            'type' => 'select',
            'options' => ['M' => 'Masculino', 'F' => 'Femenino'],
            'empty' => 'Seleccione el Genero',
            'class' => 'form-control',
            'label' => 'Sexo'
        ]); ?>
    </div>
    <!-- <div class="col-md-6 mb-3">
        <?= $this->Form->control('historiaClinica.departamento_id', ['options' => $departamentos, 'class' => 'form-control', 'empty' => true, 'label' => 'Departamento']) ?>
    </div> -->
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('historiaClinica.departamento_id', [
            'options' => $departamentos,
            'class' => 'form-control',
            'empty' => 'Seleccione Departamento',
            'label' => 'Procedencia'
        ]) ?>
    </div>

    <!-- Datos de la Cita -->
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('historiaClinica.tipo_orden', ['class' => 'form-control', 'label' => 'Tratamiento de interes']) ?>
    </div>
    
   <!-- Usuario que registra -->
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('historiaClinica.user_id', [
            'options' => $users,
            'value' => $usuario->id,
            'disabled' => true,
            'class' => 'form-control',
            'label' => 'Usuario que registra'
        ]) ?>
        <?= $this->Form->hidden('historiaClinica.user_id', ['value' => $usuario->id]) ?> <!-- ← esto envía el valor -->
    </div>


    <!-- Datos Adicionales -->
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('historiaClinica.como_entero', ['class' => 'form-control', 'label' => '¿Cómo se enteró?']) ?>
    </div>
    <div class="col-md-12 mb-3">
        <?= $this->Form->control('historiaClinica.obs_administrativas', ['class' => 'form-control', 'label' => 'Observaciones Administrativas']) ?>
    </div>
    <div class="col-md-12 mb-3">
        <?= $this->Form->control('historiaClinica.ocupacion', ['class' => 'form-control', 'label' => 'Ocupación']) ?>
    </div>
    <div class="col-md-12 mb-3">
        <?= $this->Form->control('historiaClinica.medicacion', ['class' => 'form-control', 'label' => 'Medicacion']) ?>
    </div>
    <div class="col-md-12 mb-3">
        <?= $this->Form->control('historiaClinica.alergias', ['class' => 'form-control', 'label' => 'Reacciones adversas a medicamentos']) ?>
    </div>
    <div class="col-md-12 mb-3">
        <?= $this->Form->control('historiaClinica.enfermedades', ['class' => 'form-control', 'label' => 'Enfermedades']) ?>
    </div>

    <!-- Botones -->
    <div class="col-12 text-center mt-3">
        <?= $this->Form->button('Guardar Paciente', ['type' => 'submit', 'class' => 'btn btn-primary', 'id' => 'btnGuardar']) ?>
        <?= $this->Html->link(__('Cancelar'), ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
    </div>

    <?= $this->Form->end() ?>
</div>

<script>
    document.getElementById('fecha-nacimiento').addEventListener('change', function() {
        var fechaNacimiento = new Date(this.value);
        var hoy = new Date();
        var edad = hoy.getFullYear() - fechaNacimiento.getFullYear();
        var mes = hoy.getMonth() - fechaNacimiento.getMonth();
    
        if (mes < 0 || (mes === 0 && hoy.getDate() < fechaNacimiento.getDate())) {
            edad--;
        }
    
        document.getElementById('edad').value = edad;
    });

    document.addEventListener("DOMContentLoaded", function() {
        const form = document.querySelector("form"); // Obtiene el formulario
        const btnGuardar = document.getElementById("btnGuardar");

        form.addEventListener("submit", function(event) {
            if (!form.checkValidity()) {
                event.preventDefault(); // Evita que el formulario se envíe si no es válido
                return;
            }
            btnGuardar.disabled = true;
            btnGuardar.innerText = "Guardando...";
        });
    });
</script>