<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Procedimiento $procedimiento
 */
?>

<div class="container mt-4 mb-4">
    <?= $this->Form->create($procedimiento, ['type' => 'file','class' => 'row g-3']) ?>

    <!-- Información del Procedimiento -->
    <div class="col-12 mb-4">
        <h3 class="text-info"><i class="fas fa-notes-medical"></i> Agregar Procedimiento</h3>
    </div>

    <!-- Campo Doctor -->
    <div class="col-md-12 mb-3">
<?php
if ($usuario->rol == 3 && !empty($procedimiento->doctor_id)) {
    echo $this->Form->control('doctor_id', [
        'type' => 'hidden',
        'value' => $procedimiento->doctor_id
    ]);
} else {
    echo $this->Form->control('doctor_id', [
        'label' => 'Doctor',
        'options' => $doctores,
        'class' => 'form-control mb-2',
        'empty' => 'Seleccione un doctor'
    ]);
}
?>
    </div>

    <!-- Campo Historia -->
    <div class="col-md-12 mb-3">
        <?= $this->Form->control('historia_id', [
            'label' => 'Paciente',
            'class' => 'form-control',
            'options' => $historias,
            'disabled' => ($procedimiento->historia_id) ? true : false
        ]) ?>
    </div>    

    <!-- Campo Procedimiento -->
    <div class="col-md-12 mb-3">
        <?= $this->Form->control('procedimiento', [
            'label' => 'Nombre del Procedimiento',
            'class' => 'form-control',
            'placeholder' => 'Ejemplo: Limpieza facial',
        ]) ?>
    </div>

    <div class="col-md-12 mb-3">
        <?= $this->Form->control('documentos_temp', [
            'type' => 'file',
            'label' => 'Agregar Documento',
            'class' => 'form-control',
            'id' => 'documentosTemp',
            'multiple' => true,
        ]) ?>
    </div>
            
    <!-- Lista visual de archivos -->
    <div class="col-md-12 mb-3">
        <label>Archivos seleccionados:</label>
        <ul id="lista-documentos" class="list-group"></ul>
    </div>
            
    <!-- Campo oculto real que se enviará -->
    <input type="file" name="documentos[]" id="documentosFinal" style="display:none;" multiple>

    <!-- Botones -->
    <div class="col-12 text-center mt-3">
        <?= $this->Form->button('Guardar Procedimiento', [
            'type' => 'submit',
            'class' => 'btn btn-primary',
            'id' => 'btnGuardar'
        ]) ?>
        <?= $this->Html->link(__('Cancelar'), ['controller' => 'Pacientes', 'action' => 'view', $historia->paciente_id], ['class' => 'btn btn-secondary']) ?>
    </div>

    <?= $this->Form->end() ?>
</div>

<script>
    const form = document.querySelector("form");
    const btnGuardar = document.getElementById("btnGuardar");
    
    if (form && btnGuardar) {
        form.addEventListener("submit", function(event) {
            if (!form.checkValidity()) {
                event.preventDefault(); // Evita que el formulario se envíe si no es válido
                return;
            }
            btnGuardar.disabled = true;
            btnGuardar.innerText = "Guardando...";
        });
    }
</script>
<script>
        var initializeFormLogic = (context) => {
        if (context.dataset.formLogicInitialized) return;
        context.dataset.formLogicInitialized = true;
        console.log("initializeFormLogic ejecutado en:", context);

        const inputTemp = context.querySelector('#documentosTemp');
        const inputFinal = context.querySelector('#documentosFinal');
        const lista = context.querySelector('#lista-documentos');

        if (!inputTemp || !inputFinal || !lista) return;

        let archivosSeleccionados = [];

inputTemp.addEventListener('change', function () {
    const nuevosArchivos = Array.from(this.files);
    if (!nuevosArchivos.length) return;

    nuevosArchivos.forEach(nuevoArchivo => {
        if (archivosSeleccionados.some(file => file.name === nuevoArchivo.name)) {
            // Evita duplicados por nombre (opcional, podrías usar algo más robusto si quieres)
            console.warn("Archivo duplicado:", nuevoArchivo.name);
            return;
        }

        archivosSeleccionados.push(nuevoArchivo);
    });

    actualizarListaVisual();
    actualizarInputFinal();

    // Resetea el input para poder volver a subir los mismos archivos si se desea
    inputTemp.value = '';
});


        function actualizarListaVisual() {
            lista.innerHTML = '';
            archivosSeleccionados.forEach((file, index) => {
                const li = document.createElement('li');
                li.className = 'list-group-item d-flex justify-content-between align-items-center';
                li.textContent = file.name;

                const btnEliminar = document.createElement('button');
                btnEliminar.textContent = 'x';
                btnEliminar.className = 'btn btn-sm btn-danger';
                btnEliminar.onclick = function () {
                    archivosSeleccionados.splice(index, 1);
                    actualizarListaVisual();
                    actualizarInputFinal();
                };

                li.appendChild(btnEliminar);
                lista.appendChild(li);
            });
        }

        function actualizarInputFinal() {
            const dataTransfer = new DataTransfer();
            archivosSeleccionados.forEach(file => dataTransfer.items.add(file));
            inputFinal.files = dataTransfer.files;
        }
    };
document.addEventListener('shown.bs.modal', function (event) {
    const modal = event.target;
    const modalContent = modal.querySelector('.modal-content');

    if (!modalContent) {
        console.warn('No se encontró .modal-content dentro del modal');
        return;
    }

    if (!modal.classList.contains('initialized')) {
        initializeFormLogic(modalContent);
        modal.classList.add('initialized');
    }
});

function runInitializers(context) {
    initializeFormLogic(context);
}
// Al cargar la página
document.addEventListener("DOMContentLoaded", function () {
    runInitializers(document);
});

// Cuando se abre un modal
$(document).on('shown.bs.modal', function (e) {
    const modalContent = e.target.querySelector('.modal-content');
    if (modalContent) {
        runInitializers(modalContent);
    }
});

// Si usas AJAX (por ejemplo, al cargar contenido por Pjax, Turbo, etc.)
$(document).on('ajaxComplete', function () {
    runInitializers(document);
});
$(document).on('hidden.bs.modal', function (e) {
    const modalContent = e.target.querySelector('.modal-content');
    if (modalContent) {
        delete modalContent.dataset.formLogicInitialized;
    }
});
</script>

<style>
    #listaRecetasFiltradas li {
        padding: 10px;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    #listaRecetasFiltradas li:hover {
        /* background-color: #6c757d; */
        background-color: #e2e6ea;
    }

</style>