<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 */
?>

<div class="container mt-4 mb-4">
    <?= $this->Form->create($user, ['class' => 'row g-3']) ?>

    <!-- Información del Usuario -->
    <div class="col-12 mb-4">
        <h3 class="text-info"><i class="fas fa-user-edit"></i> Editar Usuario</h3>
    </div>

    <!-- Campo: Username -->
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('username', [
            'label' => 'Nombre de Usuario',
            'class' => 'form-control',
            'placeholder' => 'Ejemplo: usuario123'
        ]) ?>
    </div>

    <!-- Campo: Password -->
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('password', [
            'label' => 'Contraseña',
            'type' => 'password',
            'class' => 'form-control',
            'placeholder' => 'Ingrese una nueva contraseña si desea cambiarla'
        ]) ?>
    </div>

    <!-- Campo: Rol (con valores 1, 2, 3) -->
    <div class="col-md-6 mb-3">
        <?= $this->Form->control('rol', [
            'label' => 'Rol del Usuario',
            'class' => 'form-control',
            'type' => 'select',
            'options' => [
                1 => 'Administrador',
                2 => 'Recepcionista',
                3 => 'Doctor',
            ],
            'value' => $user->rol, // Asigna el valor actual del rol
            'disabled' => ($user->rol == 3),
        ]) ?>
    </div>

    <!-- Botones -->
    <div class="col-12 text-center">
        <?= $this->Form->button(__('Guardar Cambios'), ['class' => 'btn btn-info']) ?>
        <?= $this->Html->link(__('Cancelar'), ['action' => 'index'], ['class' => 'btn btn-secondary me-2']) ?>
        
    </div>

    <?= $this->Form->end() ?>
</div>
