<?php
// export_pdf.php
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Productos</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 0;
        }
        h1 {
            text-align: center;
            margin-top: 20px;
            font-size: 18px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            margin: 20px;
        }
        .header div {
            width: 48%;
        }
        .table-wrapper {
            margin: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
            overflow: hidden;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
        }
    </style>
</head>
<body>

    <h1>Reporte de Productos</h1>

    <div class="header">
        <div>
            <strong>Fecha de inicio:</strong> <?php echo h($startDate); ?>
        </div>
        <div>
            <strong>Fecha de fin:</strong> <?php echo h($endDate); ?>
        </div>
    </div>

    <div class="table-wrapper">
        <table>
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Proveedor</th>
                    <th>Contacto</th>
                    <th>Tipo Transacción</th>
                    <th>Cantidad</th>
                    <th>Precio</th>
                    <th>Fecha</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($reportes)): ?>
                    <?php foreach ($reportes as $reporte): ?>
                        <tr>
                            <td><?php echo h($reporte->nombre_producto); ?></td>
                            <td><?php echo h($reporte->proveedor_nombre); ?></td>
                            <td><?php echo h($reporte->contacto_nombre); ?></td>
                            <td><?php echo h($reporte->tipo_transaccion); ?></td>
                            <td><?php echo h($reporte->cantidad_transaccion); ?></td>
                            <td><?php echo h($reporte->precio); ?></td>
                            <td><?php echo h($reporte->fecha_transaccion); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" style="text-align: center;">No se encontraron resultados</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

<h3>Stock Actual de Todos los Productos</h3>
<div class="table-wrapper">
<table>
    <thead>
        <tr>
            <th>Producto</th>
            <th>Stock Actual</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($productos as $producto): ?>
            <tr>
                <td><?= h($producto->nombre_producto) ?></td>
                <td><?= h($producto->stock_actual) ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>
</div>
    <div class="footer" style="margin-top: 30px;">
        <p>Generado el: <?= date('d/m/Y H:i') ?></p>
    </div>

</body>
</html>

<?php
?>